/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util.text.messages.multiline;

import de.z0rdak.yawp.api.commands.Commands;
import de.z0rdak.yawp.core.area.DisplayType;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.text.Messages;
import de.z0rdak.yawp.util.text.messages.multiline.MultiLineMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class VisualizationOptionsMessage
implements MultiLineMessage<IMarkableArea> {
    private final IMarkableRegion region;
    private final List<class_2561> infoLines;

    public VisualizationOptionsMessage(IMarkableRegion region) {
        this.region = region;
        this.infoLines = new ArrayList<class_2561>();
    }

    @Override
    public List<class_2561> getLines() {
        this.infoLines.clear();
        class_5250 header = ChatComponentBuilder.buildHeader(class_2561.method_48322((String)"cli.msg.info.header.of", (String)"== %s of %s ==", (Object[])new Object[]{ChatLinkBuilder.buildRegionVisualizationLink(this.region), ChatLinkBuilder.buildRegionInfoLink(this.region)}));
        class_5250 showSubject = class_2561.method_48321((String)"cli.msg.info.region.visualization.show", (String)"Show");
        class_5250 hideSubject = class_2561.method_48321((String)"cli.msg.info.region.visualization.hide", (String)"Hide");
        class_5250 hierarchySubject = class_2561.method_48321((String)"cli.msg.info.region.visualization.hierarchy", (String)"Hierarchy");
        class_5250 intersectingSubject = class_2561.method_48321((String)"cli.msg.info.region.visualization.intersecting", (String)"Intersecting");
        class_5250 customShowLink = VisualizationOptionsMessage.buildShowAdvancedLink(this.region, DisplayType.FRAME, class_2960.method_60656((String)"cyan_stained_glass"), true, 15);
        class_5250 displayActions = ChatComponentBuilder.buildInfoComponent(showSubject, VisualizationOptionsMessage.buildShowLinks(this.region), customShowLink);
        class_5250 hideActions = ChatComponentBuilder.buildInfoComponent(hideSubject, VisualizationOptionsMessage.buildHideLinks(this.region));
        class_5250 hierarchy = ChatComponentBuilder.buildInfoComponent(hierarchySubject, VisualizationOptionsMessage.buildHierarchyShowLink(this.region), VisualizationOptionsMessage.buildHierarchyHideLink(this.region));
        class_5250 intersecting = ChatComponentBuilder.buildInfoComponent(intersectingSubject, VisualizationOptionsMessage.buildIntersectingShowLink(this.region), VisualizationOptionsMessage.buildIntersectingHideLink(this.region));
        this.infoLines.add((class_2561)header);
        this.infoLines.add((class_2561)displayActions);
        this.infoLines.add((class_2561)hideActions);
        this.infoLines.add((class_2561)hierarchy);
        this.infoLines.add((class_2561)intersecting);
        return this.infoLines;
    }

    @Override
    public IMarkableArea getContent() {
        return this.region.getArea();
    }

    public static class_5250 buildShowLinks(IMarkableRegion region) {
        class_5250 frameLink = VisualizationOptionsMessage.buildShowLink(region, DisplayType.FRAME);
        class_5250 hullLink = VisualizationOptionsMessage.buildShowLink(region, DisplayType.HULL);
        class_5250 minimalLink = VisualizationOptionsMessage.buildShowLink(region, DisplayType.MINIMAL);
        class_5250 markedLink = VisualizationOptionsMessage.buildShowLink(region, DisplayType.MARKED);
        return Messages.substitutable("%s %s %s %s", frameLink, hullLink, minimalLink, markedLink);
    }

    public static class_5250 buildShowAdvancedLink(IMarkableRegion region, DisplayType displayType, class_2960 block, boolean glow, int lightLevel) {
        String cmd = Commands.buildAdvancedVisualizationShowCommand(region, displayType, block, glow, lightLevel);
        class_5250 text = class_2561.method_48321((String)"cli.msg.info.region.visualization.show.advanced.link.text", (String)"custom");
        class_5250 hover = class_2561.method_48322((String)"cli.msg.info.region.visualization.show.advanced.link.hover", (String)"Click to paste custom visualization command for '%s'", (Object[])new Object[]{displayType.name, region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, cmd, class_2558.class_2559.field_11745, Messages.LINK_COLOR);
    }

    public static class_5250 buildHideLinks(IMarkableRegion region) {
        class_5250 frameLink = VisualizationOptionsMessage.buildHideLink(region, DisplayType.FRAME);
        class_5250 hullLink = VisualizationOptionsMessage.buildHideLink(region, DisplayType.HULL);
        class_5250 minimalLink = VisualizationOptionsMessage.buildHideLink(region, DisplayType.MINIMAL);
        class_5250 markedLink = VisualizationOptionsMessage.buildHideLink(region, DisplayType.MARKED);
        return Messages.substitutable("%s %s %s %s", frameLink, hullLink, minimalLink, markedLink);
    }

    public static class_5250 buildShowLink(IMarkableRegion region, DisplayType displayType) {
        class_5250 text = class_2561.method_48322((String)"cli.msg.info.region.visualization.show.link.text", (String)"%s", (Object[])new Object[]{displayType.name});
        class_5250 hover = class_2561.method_48322((String)"cli.msg.info.region.visualization.show.link.hover", (String)"Click to show %s-Visualization for '%s'", (Object[])new Object[]{displayType.name, region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, Commands.buildVisualizationShowCommand(region, displayType), class_2558.class_2559.field_11750, Messages.LINK_COLOR);
    }

    public static class_5250 buildHideLink(IMarkableRegion region, DisplayType displayType) {
        class_5250 text = class_2561.method_48322((String)"cli.msg.info.region.visualization.hide.link.text", (String)"%s", (Object[])new Object[]{displayType.name});
        class_5250 hover = class_2561.method_48322((String)"cli.msg.info.region.visualization.hide.link.hover", (String)"Click to hide %s-Visualization for '%s'", (Object[])new Object[]{displayType.name, region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, Commands.buildVisualizationHideCommand(region, displayType), class_2558.class_2559.field_11750, Messages.LINK_COLOR);
    }

    public static class_5250 buildHierarchyShowLink(IMarkableRegion region) {
        class_5250 text = class_2561.method_48321((String)"cli.msg.info.region.visualization.hierarchy.show.link.text", (String)"Show");
        class_5250 hover = class_2561.method_48322((String)"cli.msg.info.region.visualization.hierarchy.show.link.hover", (String)"Click to show visualization for all child regions of '%s'", (Object[])new Object[]{region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, Commands.buildVisualizationShowHierarchyCommand(region), class_2558.class_2559.field_11750, Messages.LINK_COLOR);
    }

    public static class_5250 buildHierarchyHideLink(IMarkableRegion region) {
        class_5250 text = class_2561.method_48321((String)"cli.msg.info.region.visualization.hierarchy.hide.link.text", (String)"Hide");
        class_5250 hover = class_2561.method_48322((String)"cli.msg.info.region.visualization.hierarchy.hide.link.hover", (String)"Click to hide visualization for all child regions of '%s'", (Object[])new Object[]{region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, Commands.buildVisualizationHideHierarchyCommand(region), class_2558.class_2559.field_11750, Messages.LINK_COLOR);
    }

    public static class_5250 buildIntersectingHideLink(IMarkableRegion region) {
        class_5250 text = class_2561.method_48321((String)"cli.msg.info.region.visualization.intersecting.hide.link.text", (String)"Hide");
        class_5250 hover = class_2561.method_48322((String)"cli.msg.info.region.visualization.intersecting.hide.link.hover", (String)"Click to hide visualization of intersecting regions for '%s'", (Object[])new Object[]{region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, Commands.buildVisualizationHideIntersectingCommand(region), class_2558.class_2559.field_11750, Messages.LINK_COLOR);
    }

    public static class_5250 buildIntersectingShowLink(IMarkableRegion region) {
        class_5250 text = class_2561.method_48321((String)"cli.msg.info.region.visualization.intersecting.show.link.text", (String)"Show");
        class_5250 hover = class_2561.method_48322((String)"cli.msg.info.region.visualization.intersecting.show.link.hover", (String)"Click to show visualization of intersecting regions for '%s'", (Object[])new Object[]{region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, Commands.buildVisualizationShowIntersectingCommand(region), class_2558.class_2559.field_11750, Messages.LINK_COLOR);
    }
}

